// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/common/vr_service.mojom
//

package org.chromium.mojom.content;

public final class VrDeviceInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 32;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public int index;
    public String deviceName;
    public VrhmdInfo hmdInfo;

    private VrDeviceInfo(int version) {
        super(STRUCT_SIZE, version);
    }

    public VrDeviceInfo() {
        this(0);
    }

    public static VrDeviceInfo deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static VrDeviceInfo decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        VrDeviceInfo result = new VrDeviceInfo(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.index = decoder0.readInt(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.deviceName = decoder0.readString(16, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
            result.hmdInfo = VrhmdInfo.decode(decoder1);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(index, 8);
        encoder0.encode(deviceName, 16, false);
        encoder0.encode(hmdInfo, 24, true);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        VrDeviceInfo other = (VrDeviceInfo) object;
        if (this.index != other.index)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.deviceName, other.deviceName))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.hmdInfo, other.hmdInfo))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(index);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(deviceName);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(hmdInfo);
        return result;
    }
}

